/**************************************************************************
MODULE:    CRC
CONTAINS:  CRC calculation for CANopenIA serial communication
COPYRIGHT: Embedded Systems Academy, Inc. 2008-2017.
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   Free to use with licensed CANopenIA chips, modules or devices
           like CANgineBerry, CANgineXXX and 447izer
VERSION:   1.10, EmSA 10-NOV-17
           $LastChangedDate: 2018-07-02 17:02:15 +0200 (Mo, 02 Jul 2018) $
           $LastChangedRevision: 4313 $
***************************************************************************/ 

#pragma once

//#include <windows.h>

/**************************************************************************
DOES:    Initializes CRC calculation
RETURNS: Nothing
**************************************************************************/
extern void CRC_Init(
  void
);

/**************************************************************************
DOES:    Adds a byte to the CRC value calculation
RETURNS: Nothing
**************************************************************************/
extern void CRC_Add(
  unsigned char data                                       // byte to add
);

/**************************************************************************
DOES:    Finalizes the CRC calculation
RETURNS: CRC value
**************************************************************************/
extern unsigned short CRC_Finalize(
  void
);

/*----------------------- END OF FILE ----------------------------------*/
